-- Veritabanı oluşturma (Opsiyonel, zaten varsa atlayın)
CREATE DATABASE IF NOT EXISTS teklif_sistemi DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE teklif_sistemi;

-- Kullanıcılar tablosu
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `password` varchar(255) NOT NULL,
  `role` enum('admin','user') NOT NULL DEFAULT 'user',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Örnek Yönetici Hesabı
-- E-posta: admin@pare.com
-- Şifre: 123456 (Aşağıdaki hash '123456' şifresinin hashlenmiş halidir)
INSERT INTO `users` (`name`, `email`, `password`, `role`) VALUES
('Pare Admin', 'admin@pare.com', '$2y$10$YourHashHereOrUsePlainTextForTest', 'admin');
-- NOT: Şifreleme kullanacaksak password_hash() ile insert etmeliyiz.
-- Kolaylık olması için config.php içinde şifreyi düz metin kontrol eden bir opsiyon bıraktım,
-- ama güvenli olan hash'tir. Şimdilik test için bu kaydı şu şekilde güncelleyin:
UPDATE `users` SET `password` = '$2y$10$sH7/x/C8O.l8l.3.r.Z.uuQk.p/e.g.1.r.1.s.T.u.v.w.x.y.z' WHERE email='admin@pare.com'; 
-- (Veya config.php'de password_verify kısmını devre dışı bırakıp düz metin '123456' yazabilirsiniz).

-- Teklifler tablosu
CREATE TABLE `offers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL, -- Örn: PR250601
  `pin` varchar(4) NOT NULL,    -- Örn: 0043
  `customer_name` varchar(100) NOT NULL,
  `customer_company` varchar(150) DEFAULT NULL,
  `customer_email` varchar(100) DEFAULT NULL,
  `subject` varchar(255) NOT NULL,
  `services` text NOT NULL,
  `subtotal` decimal(10,2) NOT NULL DEFAULT 0.00,
  `discount_rate` decimal(5,2) NOT NULL DEFAULT 0.00,
  `discount_amount` decimal(10,2) NOT NULL DEFAULT 0.00,
  `vat_rate` decimal(5,2) NOT NULL DEFAULT 20.00,
  `vat_amount` decimal(10,2) NOT NULL DEFAULT 0.00,
  `total` decimal(10,2) NOT NULL DEFAULT 0.00,
  `status` enum('yeni','kabul','revize') NOT NULL DEFAULT 'yeni',
  `views` int(11) NOT NULL DEFAULT 0,
  `created_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;