<?php
// config.php
session_start();

// Veritabanı Ayarları
$db_host = 'localhost';
$db_name = 'teklif_sistemi';
$db_user = 'root';      // Kendi DB kullanıcınızı yazın
$db_pass = '';          // Kendi DB şifrenizi yazın

try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Veritabanı hatası: " . $e->getMessage());
}

// Yardımcı Fonksiyonlar

// Giriş kontrolü
function requireLogin() {
    if (!isset($_SESSION['user_id'])) {
        header("Location: login.php");
        exit;
    }
}

// Para formatı (TL)
function formatMoney($amount) {
    return number_format($amount, 2, ',', '.') . ' ₺';
}

// PIN Üretici (4 haneli, string)
function generatePin() {
    return str_pad(mt_rand(0, 9999), 4, '0', STR_PAD_LEFT);
}

// Teklif Kodu Üretici (PRyymmXX)
function generateOfferCode($pdo) {
    $year = date('y');
    $month = date('m');
    $prefix = "PR{$year}{$month}"; // Örn: PR2511

    // Bu ayki teklif sayısını bul
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM offers WHERE code LIKE ?");
    $stmt->execute(["$prefix%"]);
    $count = $stmt->fetchColumn();

    $sequence = str_pad($count + 1, 2, '0', STR_PAD_LEFT);
    return $prefix . $sequence;
}

// XSS Koruması için
function e($string) {
    return htmlspecialchars($string ?? '', ENT_QUOTES, 'UTF-8');
}
?>