<?php
require 'config.php';

// Eğer zaten giriş yapıldıysa yönlendir
if (isset($_SESSION['user_id'])) {
    header("Location: offers.php");
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';

    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch();

    // Basitlik adına şimdilik plain text de kabul edecek mantık (Geliştirme aşaması için)
    // Normalde sadece password_verify kullanılmalı.
    if ($user) {
        // Şifre hash mi yoksa düz metin mi kontrolü (Geçiş kolaylığı için)
        $verify = password_verify($password, $user['password']);
        
        // Eğer hash verify başarısızsa ve DB'de düz metin varsa (örn: test için 123456)
        if (!$verify && $password === $user['password']) {
            $verify = true; 
        }

        if ($verify) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_name'] = $user['name'];
            $_SESSION['user_role'] = $user['role'];
            header("Location: offers.php");
            exit;
        } else {
            $error = "Hatalı şifre.";
        }
    } else {
        $error = "Kullanıcı bulunamadı.";
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Giriş Yap - Pare Teklif</title>
    <style>
        body { font-family: sans-serif; background: #f4f6f8; display: flex; align-items: center; justify-content: center; height: 100vh; margin: 0; }
        .login-box { background: white; padding: 40px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); width: 100%; max-width: 320px; }
        h2 { text-align: center; color: #333; margin-top: 0; }
        .form-group { margin-bottom: 15px; }
        label { display: block; margin-bottom: 5px; font-weight: bold; font-size: 14px; color: #555; }
        input { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 4px; box-sizing: border-box; }
        button { width: 100%; padding: 10px; background: #007bff; color: white; border: none; border-radius: 4px; cursor: pointer; font-weight: bold; }
        button:hover { background: #0056b3; }
        .error { color: red; font-size: 13px; text-align: center; margin-bottom: 10px; }
    </style>
</head>
<body>
    <div class="login-box">
        <h2>Pare Teklif Girişi</h2>
        <?php if($error): ?><div class="error"><?= e($error) ?></div><?php endif; ?>
        <form method="post">
            <div class="form-group">
                <label>E-posta</label>
                <input type="email" name="email" required autofocus>
            </div>
            <div class="form-group">
                <label>Şifre</label>
                <input type="password" name="password" required>
            </div>
            <button type="submit">Giriş Yap</button>
        </form>
    </div>
</body>
</html>