<?php
require 'config.php';
requireLogin();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Form verilerini al
    $customer_name = $_POST['customer_name'];
    $customer_company = $_POST['customer_company'];
    $customer_email = $_POST['customer_email'];
    $subject = $_POST['subject'];
    $services = $_POST['services'];
    
    // Sayısal veriler
    $subtotal = floatval($_POST['subtotal']);
    $discount_rate = floatval($_POST['discount_rate']);
    $vat_rate = 20.00; // Sabit %20 KDV varsayımı

    // Hesaplamalar
    $discount_amount = $subtotal * ($discount_rate / 100);
    $after_discount = $subtotal - $discount_amount;
    $vat_amount = $after_discount * ($vat_rate / 100);
    $total = $after_discount + $vat_amount;

    // Kod ve PIN üret
    $code = generateOfferCode($pdo);
    $pin = generatePin();

    // DB Kayıt
    $sql = "INSERT INTO offers 
            (code, pin, customer_name, customer_company, customer_email, subject, services, subtotal, discount_rate, discount_amount, vat_rate, vat_amount, total, status, created_by)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'yeni', ?)";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        $code, $pin, $customer_name, $customer_company, $customer_email, $subject, $services, 
        $subtotal, $discount_rate, $discount_amount, $vat_rate, $vat_amount, $total, $_SESSION['user_id']
    ]);

    // Kayıt sonrası görüntüleme sayfasına git
    $new_id = $pdo->lastInsertId();
    header("Location: offer_view.php?id=$new_id");
    exit;
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Yeni Teklif - Pare</title>
    <style>
        body { font-family: sans-serif; background: #f4f6f8; padding: 20px; }
        .container { max-width: 700px; margin: 0 auto; background: white; padding: 30px; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.05); }
        h2 { margin-top: 0; border-bottom: 1px solid #eee; padding-bottom: 15px; }
        .form-row { display: flex; gap: 15px; margin-bottom: 15px; }
        .form-group { flex: 1; }
        label { display: block; margin-bottom: 5px; font-weight: bold; font-size: 14px; color: #555; }
        input, textarea { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 4px; box-sizing: border-box; font-family: inherit; }
        textarea { height: 150px; resize: vertical; }
        .btn-submit { background: #28a745; color: white; border: none; padding: 12px 20px; border-radius: 4px; font-size: 16px; cursor: pointer; width: 100%; font-weight: bold; }
        .btn-submit:hover { background: #218838; }
        .back-link { display: block; margin-bottom: 20px; color: #666; text-decoration: none; }
    </style>
</head>
<body>
    <a href="offers.php" class="back-link">&larr; Listeye Dön</a>
    <div class="container">
        <h2>Yeni Teklif Oluştur</h2>
        <form method="post">
            <div class="form-row">
                <div class="form-group">
                    <label>Müşteri Adı Soyadı</label>
                    <input type="text" name="customer_name" required>
                </div>
                <div class="form-group">
                    <label>Müşteri Firma</label>
                    <input type="text" name="customer_company">
                </div>
            </div>
            
            <div class="form-group">
                <label>Müşteri E-posta</label>
                <input type="email" name="customer_email">
            </div>

            <div class="form-group">
                <label>Teklif Konusu</label>
                <input type="text" name="subject" placeholder="Örn: Web Sitesi Tasarımı" required>
            </div>

            <div class="form-group">
                <label>Hizmet Kapsamı / Açıklama</label>
                <textarea name="services" placeholder="Teklifin detaylarını maddeler halinde buraya yazınız..." required></textarea>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label>Ara Toplam (KDV Hariç)</label>
                    <input type="number" step="0.01" name="subtotal" required>
                </div>
                <div class="form-group">
                    <label>İndirim Oranı (%)</label>
                    <input type="number" step="0.01" name="discount_rate" value="0">
                </div>
            </div>
            
            <p style="font-size:12px; color:#666; margin-top:0;">* KDV otomatik %20 hesaplanacaktır.</p>

            <button type="submit" class="btn-submit">Teklifi Oluştur</button>
        </form>
    </div>
</body>
</html>