<?php
require 'config.php';
requireLogin();

$id = $_GET['id'] ?? 0;
$stmt = $pdo->prepare("SELECT * FROM offers WHERE id = ?");
$stmt->execute([$id]);
$offer = $stmt->fetch();

if (!$offer) die("Teklif bulunamadı.");

// Manuel durum güncelleme (istenirse)
if (isset($_POST['update_status'])) {
    $new_status = $_POST['status'];
    $stmt = $pdo->prepare("UPDATE offers SET status = ? WHERE id = ?");
    $stmt->execute([$new_status, $id]);
    header("Location: offer_view.php?id=$id");
    exit;
}

// Public URL
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
$host = $_SERVER['HTTP_HOST'];
$path = dirname($_SERVER['PHP_SELF']);
$public_url = "$protocol://$host$path/public.php?code=" . $offer['code'];

?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Teklif Detayı - <?= e($offer['code']) ?></title>
    <style>
        body { font-family: sans-serif; background: #f4f6f8; padding: 20px; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 30px; border-radius: 8px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); }
        .header { display: flex; justify-content: space-between; border-bottom: 1px solid #eee; padding-bottom: 15px; margin-bottom: 20px; }
        .info-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 30px; }
        .info-box { background: #f9f9f9; padding: 15px; border-radius: 4px; }
        .info-box h3 { margin: 0 0 10px 0; font-size: 14px; color: #666; text-transform: uppercase; }
        .big-code { font-size: 24px; font-weight: bold; color: #333; letter-spacing: 1px; }
        .pin-code { font-size: 18px; color: #d9534f; font-family: monospace; font-weight: bold; border: 1px dashed #d9534f; padding: 2px 6px; border-radius: 3px;}
        .action-bar { background: #e3f2fd; padding: 15px; border-radius: 4px; display: flex; align-items: center; justify-content: space-between; }
        input.url-box { width: 60%; padding: 8px; border: 1px solid #ccc; border-radius: 4px; }
        .back-link { display: inline-block; margin-bottom: 15px; text-decoration: none; color: #555; }
        .financials { width: 100%; border-collapse: collapse; margin-top: 20px; }
        .financials td { padding: 8px; border-bottom: 1px solid #eee; }
        .financials tr:last-child td { font-weight: bold; font-size: 1.1em; border-bottom: none; }
    </style>
</head>
<body>
    <a href="offers.php" class="back-link">&larr; Listeye Dön</a>
    
    <div class="container">
        <div class="header">
            <div>
                <div class="big-code"><?= e($offer['code']) ?></div>
                <span style="color:#888; font-size:14px;"><?= date('d.m.Y H:i', strtotime($offer['created_at'])) ?> tarihinde oluşturuldu.</span>
            </div>
            <div style="text-align: right;">
                <div style="margin-bottom:5px;">Durum: <b><?= strtoupper($offer['status']) ?></b></div>
                <div>Görüntülenme: <b><?= $offer['views'] ?></b></div>
            </div>
        </div>

        <div class="action-bar">
            <div style="flex:1;">
                <strong>Müşteri Linki:</strong><br>
                <input type="text" class="url-box" value="<?= $public_url ?>" readonly onclick="this.select()">
                <a href="<?= $public_url ?>" target="_blank" style="margin-left:10px;">Aç</a>
            </div>
            <div style="text-align: right;">
                <strong>PIN Kodu:</strong><br>
                <span class="pin-code"><?= e($offer['pin']) ?></span>
            </div>
        </div>
        <br>

        <div class="info-grid">
            <div class="info-box">
                <h3>Müşteri Bilgileri</h3>
                <p>
                    <b><?= e($offer['customer_name']) ?></b><br>
                    <?= e($offer['customer_company']) ?><br>
                    <?= e($offer['customer_email']) ?>
                </p>
            </div>
            <div class="info-box">
                <h3>Teklif Özeti</h3>
                <p>
                    Konu: <?= e($offer['subject']) ?><br>
                    Tutar: <b><?= formatMoney($offer['total']) ?></b>
                </p>
                
                <form method="post" style="margin-top:15px;">
                    <label style="font-size:12px;">Durumu Değiştir:</label>
                    <select name="status">
                        <option value="yeni" <?= $offer['status']=='yeni'?'selected':'' ?>>Yeni</option>
                        <option value="kabul" <?= $offer['status']=='kabul'?'selected':'' ?>>Kabul</option>
                        <option value="revize" <?= $offer['status']=='revize'?'selected':'' ?>>Revize</option>
                    </select>
                    <button type="submit" name="update_status" style="font-size:12px;">Güncelle</button>
                </form>
            </div>
        </div>

        <h3>Hizmet Kapsamı</h3>
        <div style="white-space: pre-wrap; background: #fafafa; padding: 15px; border:1px solid #eee;"><?= e($offer['services']) ?></div>

        <h3>Fiyatlandırma</h3>
        <table class="financials">
            <tr>
                <td>Ara Toplam</td>
                <td align="right"><?= formatMoney($offer['subtotal']) ?></td>
            </tr>
            <tr>
                <td>İndirim (%<?= $offer['discount_rate'] + 0 ?>)</td>
                <td align="right">-<?= formatMoney($offer['discount_amount']) ?></td>
            </tr>
            <tr>
                <td>KDV (%<?= $offer['vat_rate'] + 0 ?>)</td>
                <td align="right"><?= formatMoney($offer['vat_amount']) ?></td>
            </tr>
            <tr>
                <td>GENEL TOPLAM</td>
                <td align="right"><?= formatMoney($offer['total']) ?></td>
            </tr>
        </table>

    </div>
</body>
</html>