<?php
require 'config.php';
requireLogin();

// Teklifleri çek
$stmt = $pdo->query("
    SELECT o.*, u.name as creator_name 
    FROM offers o 
    LEFT JOIN users u ON o.created_by = u.id 
    ORDER BY o.created_at DESC
");
$offers = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Teklifler - Pare</title>
    <style>
        body { font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif; background: #f4f6f8; margin: 0; padding: 0; }
        .navbar { background: #fff; padding: 15px 30px; border-bottom: 1px solid #ddd; display: flex; justify-content: space-between; align-items: center; }
        .navbar h1 { margin: 0; font-size: 20px; color: #333; }
        .user-menu a { margin-left: 15px; text-decoration: none; color: #555; font-size: 14px; }
        .user-menu a.btn-new { background: #28a745; color: white; padding: 8px 15px; border-radius: 4px; }
        .container { padding: 30px; max-width: 1200px; margin: 0 auto; }
        
        table { width: 100%; background: white; border-collapse: collapse; box-shadow: 0 1px 3px rgba(0,0,0,0.1); border-radius: 6px; overflow: hidden; }
        th, td { padding: 15px; text-align: left; border-bottom: 1px solid #eee; }
        th { background: #f9f9f9; font-weight: 600; color: #555; font-size: 13px; text-transform: uppercase; }
        tr:hover { background: #f1f1f1; }
        
        .status { display: inline-block; padding: 4px 8px; border-radius: 12px; font-size: 12px; font-weight: bold; }
        .status-yeni { background: #e3f2fd; color: #0d47a1; }
        .status-kabul { background: #e8f5e9; color: #1b5e20; }
        .status-revize { background: #fff3e0; color: #e65100; }
        
        .link-public { color: #007bff; text-decoration: none; font-size: 13px; }
        .link-public:hover { text-decoration: underline; }
        .row-link { text-decoration: none; color: inherit; display: block; }
    </style>
</head>
<body>
    <div class="navbar">
        <h1>Pare Teklif Sistemi</h1>
        <div class="user-menu">
            <span>Sn. <b><?= e($_SESSION['user_name']) ?></b></span>
            <a href="offer_new.php" class="btn-new">+ Yeni Teklif</a>
            <a href="logout.php">Çıkış</a>
        </div>
    </div>

    <div class="container">
        <table>
            <thead>
                <tr>
                    <th>Kod</th>
                    <th>Müşteri</th>
                    <th>Konu</th>
                    <th>Tutar</th>
                    <th>Durum</th>
                    <th>Görüntüleme</th>
                    <th>Oluşturan</th>
                    <th>Tarih</th>
                    <th>Müşteri Linki</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($offers as $o): ?>
                <tr>
                    <td><a href="offer_view.php?id=<?= $o['id'] ?>"><b><?= e($o['code']) ?></b></a></td>
                    <td><?= e($o['customer_name']) ?></td>
                    <td><?= e($o['subject']) ?></td>
                    <td><b><?= formatMoney($o['total']) ?></b></td>
                    <td>
                        <span class="status status-<?= $o['status'] ?>">
                            <?= ucfirst($o['status']) ?>
                        </span>
                    </td>
                    <td style="text-align:center"><?= $o['views'] ?></td>
                    <td><?= e($o['creator_name']) ?></td>
                    <td><?= date('d.m.Y', strtotime($o['created_at'])) ?></td>
                    <td>
                        <a href="public.php?code=<?= $o['code'] ?>" target="_blank" class="link-public">
                            Aç &#8599;
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if(empty($offers)): ?>
                    <tr><td colspan="9" style="text-align:center; color:#888;">Henüz teklif bulunmuyor.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</body>
</html>