<?php
require 'config.php';

$code = $_GET['code'] ?? '';
if (!$code) die("Geçersiz bağlantı.");

// Teklifi bul
$stmt = $pdo->prepare("SELECT * FROM offers WHERE code = ?");
$stmt->execute([$code]);
$offer = $stmt->fetch();

if (!$offer) die("Teklif bulunamadı veya yayından kaldırıldı.");

$session_key = 'offer_pin_ok_' . $offer['code'];
$error = '';
$msg = '';

// 1. Durum: PIN Gönderildiyse Kontrol Et
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['pin_check'])) {
    $input_pin = $_POST['pin'] ?? '';
    if ($input_pin === $offer['pin']) {
        $_SESSION[$session_key] = true;
        // Görüntüleme sayısını artır
        $pdo->prepare("UPDATE offers SET views = views + 1 WHERE id = ?")->execute([$offer['id']]);
        // Sayfayı yenile (POST data temizlensin)
        header("Location: public.php?code=$code");
        exit;
    } else {
        $error = "Girdiğiniz PIN kodu hatalı.";
    }
}

// 2. Durum: Müşteri Aksiyonu (Kabul / Revize)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['client_action'])) {
    $action = $_POST['client_action'];
    $new_status = ($action === 'accept') ? 'kabul' : 'revize';
    
    $stmt = $pdo->prepare("UPDATE offers SET status = ? WHERE id = ?");
    $stmt->execute([$new_status, $offer['id']]);
    
    $offer['status'] = $new_status; // Ekranda hemen güncel göstermek için
    $msg = ($action === 'accept') ? "Teklifi kabul ettiniz. Teşekkür ederiz!" : "Revize talebiniz iletildi.";
}

// PIN Doğrulanmadıysa Giriş Formunu Göster
if (!isset($_SESSION[$session_key]) || $_SESSION[$session_key] !== true) {
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Teklif Güvenlik Kontrolü</title>
    <style>
        body { font-family: sans-serif; background: #f4f6f8; display: flex; height: 100vh; align-items: center; justify-content: center; margin: 0; }
        .pin-box { background: white; padding: 40px; border-radius: 8px; text-align: center; box-shadow: 0 4px 12px rgba(0,0,0,0.1); max-width: 300px; width: 100%; }
        input { font-size: 24px; letter-spacing: 5px; text-align: center; width: 100%; padding: 10px; margin: 15px 0; border: 1px solid #ddd; border-radius: 4px; box-sizing: border-box; }
        button { width: 100%; padding: 12px; background: #333; color: white; border: none; border-radius: 4px; font-size: 16px; cursor: pointer; }
        .error { color: red; margin-bottom: 10px; font-size: 14px; }
    </style>
</head>
<body>
    <div class="pin-box">
        <h3>Güvenlik Kontrolü</h3>
        <p>Lütfen teklifi görüntülemek için size iletilen 4 haneli PIN kodunu giriniz.</p>
        <?php if($error): ?><div class="error"><?= $error ?></div><?php endif; ?>
        <form method="post">
            <input type="text" name="pin" maxlength="4" placeholder="0000" required autofocus autocomplete="off">
            <button type="submit" name="pin_check">Görüntüle</button>
        </form>
    </div>
</body>
</html>
<?php
    exit; // Kodun geri kalanını çalıştırma
}

// Buraya geldiyse PIN doğrudur, Teklifi Göster (A4 Layout)
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Teklif: <?= e($offer['subject']) ?></title>
    <style>
        /* Genel Reset ve Sayfa Yapısı */
        body { margin: 0; padding: 0; background: #e0e0e0; font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; color: #333; font-size: 14px; line-height: 1.5; }
        
        /* A4 Sayfa Kabı */
        .page {
            width: 210mm;
            min-height: 297mm;
            margin: 30px auto;
            background: white;
            padding: 15mm 20mm; /* A4 Kenar boşlukları */
            box-sizing: border-box;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            position: relative;
        }

        /* Header */
        header { display: flex; justify-content: space-between; border-bottom: 2px solid #333; padding-bottom: 20px; margin-bottom: 30px; }
        .logo { font-size: 32px; font-weight: bold; color: #333; letter-spacing: -1px; }
        .agency-info { font-size: 12px; color: #666; margin-top: 5px; }
        .offer-meta { text-align: right; }
        .offer-meta h1 { margin: 0; font-size: 24px; font-weight: normal; color: #333; }
        .meta-row { font-size: 13px; margin-top: 5px; }

        /* İki Sütun Bilgi */
        .info-section { display: flex; gap: 40px; margin-bottom: 30px; }
        .info-col { flex: 1; border: 1px solid #eee; padding: 15px; border-radius: 4px; }
        .info-title { font-size: 12px; font-weight: bold; color: #999; text-transform: uppercase; margin-bottom: 10px; letter-spacing: 0.5px; border-bottom: 1px solid #eee; padding-bottom: 5px; }
        
        /* İçerik */
        .content-section { margin-bottom: 30px; }
        .service-desc { white-space: pre-wrap; text-align: justify; }

        /* Tablo */
        .price-table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        .price-table th { text-align: left; border-bottom: 2px solid #eee; padding: 10px 5px; color: #555; }
        .price-table td { border-bottom: 1px solid #eee; padding: 10px 5px; }
        .price-table .total-row td { border-bottom: none; border-top: 2px solid #333; font-weight: bold; font-size: 16px; padding-top: 15px; }
        .text-right { text-align: right; }

        /* Durum Mesajları */
        .msg-box { text-align: center; padding: 15px; background: #d4edda; color: #155724; border-radius: 5px; margin-bottom: 20px; font-weight: bold; border: 1px solid #c3e6cb; }
        
        /* Aksiyon Butonları */
        .actions { margin-top: 40px; text-align: center; padding: 20px; background: #f9f9f9; border-radius: 8px; }
        .btn { display: inline-block; padding: 12px 25px; font-size: 15px; font-weight: bold; border: none; border-radius: 4px; cursor: pointer; margin: 0 10px; text-decoration: none; transition: background 0.2s; }
        .btn-accept { background: #28a745; color: white; }
        .btn-accept:hover { background: #218838; }
        .btn-revise { background: #ffc107; color: #333; }
        .btn-revise:hover { background: #e0a800; }

        .status-badge { padding: 5px 10px; border-radius: 4px; font-weight: bold; display: inline-block; margin-top: 5px; }
        .st-yeni { background: #e3f2fd; color: #0d47a1; }
        .st-kabul { background: #e8f5e9; color: #1b5e20; }
        .st-revize { background: #fff3e0; color: #e65100; }

        /* Footer */
        .footer { margin-top: 50px; font-size: 11px; color: #888; text-align: center; border-top: 1px solid #eee; padding-top: 15px; }

        /* Mobil Uyumluluk */
        @media (max-width: 800px) {
            .page { width: 95%; margin: 10px auto; padding: 15px; min-height: auto; }
            .info-section { flex-direction: column; gap: 15px; }
        }

        /* Yazdırma Ayarları */
        @media print {
            body { background: white; }
            .page { width: 100%; margin: 0; box-shadow: none; border: none; }
            .no-print { display: none !important; }
            .actions { display: none; }
        }
    </style>
</head>
<body>

    <div class="page">
        <?php if($msg): ?>
            <div class="msg-box no-print"><?= e($msg) ?></div>
        <?php endif; ?>

        <header>
            <div class="left">
                <div class="logo">PARE</div>
                <div class="agency-info">
                    Yaratıcı Dijital Ajans<br>
                    info@pare.com | +90 212 000 00 00
                </div>
            </div>
            <div class="offer-meta">
                <h1>TEKLİF FORMU</h1>
                <div class="meta-row">Kod: <b><?= e($offer['code']) ?></b></div>
                <div class="meta-row">Tarih: <?= date('d.m.Y', strtotime($offer['created_at'])) ?></div>
                <div class="meta-row">
                    Durum: 
                    <span class="status-badge st-<?= $offer['status'] ?>">
                        <?= strtoupper($offer['status']) ?>
                    </span>
                </div>
            </div>
        </header>

        <div class="info-section">
            <div class="info-col">
                <div class="info-title">Müşteri Bilgileri</div>
                <strong><?= e($offer['customer_company']) ?></strong><br>
                Sayın <?= e($offer['customer_name']) ?><br>
                <?= e($offer['customer_email']) ?>
            </div>
            <div class="info-col">
                <div class="info-title">Teklif Özeti</div>
                <strong>Konu:</strong> <?= e($offer['subject']) ?><br>
                <strong>Geçerlilik:</strong> Teklif tarihinden itibaren 15 gün.<br>
                <strong>Para Birimi:</strong> Türk Lirası (TL)
            </div>
        </div>

        <div class="content-section">
            <div class="info-title" style="border-bottom:2px solid #333; margin-bottom:15px;">HİZMET KAPSAMI</div>
            <div class="service-desc"><?= e($offer['services']) ?></div>
        </div>

        <div class="content-section">
            <div class="info-title" style="border-bottom:2px solid #333; margin-bottom:15px;">FİYAT ÖZETİ</div>
            <table class="price-table">
                <thead>
                    <tr>
                        <th>Açıklama</th>
                        <th class="text-right">Tutar</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>Hizmet Bedeli (Ara Toplam)</td>
                        <td class="text-right"><?= formatMoney($offer['subtotal']) ?></td>
                    </tr>
                    <?php if($offer['discount_amount'] > 0): ?>
                    <tr>
                        <td>İndirim (%<?= $offer['discount_rate'] + 0 ?>)</td>
                        <td class="text-right" style="color:red">-<?= formatMoney($offer['discount_amount']) ?></td>
                    </tr>
                    <?php endif; ?>
                    <tr>
                        <td>KDV (%<?= $offer['vat_rate'] + 0 ?>)</td>
                        <td class="text-right"><?= formatMoney($offer['vat_amount']) ?></td>
                    </tr>
                    <tr class="total-row">
                        <td>GENEL TOPLAM</td>
                        <td class="text-right"><?= formatMoney($offer['total']) ?></td>
                    </tr>
                </tbody>
            </table>
        </div>

        <!-- Aksiyon Butonları (Sadece 'yeni' veya 'revize' durumundaysa ve çıktı almıyorsak göster) -->
        <?php if($offer['status'] !== 'kabul'): ?>
        <div class="actions no-print">
            <form method="post" onsubmit="return confirm('İşlemi onaylıyor musunuz?');">
                <button type="submit" name="client_action" value="accept" class="btn btn-accept">✓ Teklifi Kabul Ediyorum</button>
                <button type="submit" name="client_action" value="revise" class="btn btn-revise">✎ Revize Talep Ediyorum</button>
            </form>
            <p style="font-size:12px; color:#999; margin-top:10px;">Butonlara tıkladığınızda talebiniz ajansımıza otomatik olarak iletilecektir.</p>
        </div>
        <?php endif; ?>

        <div class="footer">
            <p>Bu belge Pare Ajans tarafından dijital olarak oluşturulmuştur. Islak imza gerektirmez.<br>
            Sorularınız için lütfen bizimle iletişime geçiniz.</p>
        </div>
    </div>

</body>
</html>